/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util.definition;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;
import snownee.kiwi.Kiwi;
import snownee.kiwi.crafting.input.ProcessingInput;

public final class ItemDefinition
implements Comparable<ItemDefinition>,
ProcessingInput {
    public static final ItemDefinition EMPTY = ItemDefinition.of(Items.field_190931_a);
    private final IRegistryDelegate<Item> item;
    private final int metadata;

    public static ItemDefinition of(Item item) {
        return ItemDefinition.of(item, 0);
    }

    public static ItemDefinition of(ItemStack stack) {
        return stack.func_190926_b() ? ItemDefinition.of(Items.field_190931_a) : ItemDefinition.of(stack.func_77973_b(), stack.func_77981_g() ? stack.func_77960_j() : 0);
    }

    public static ItemDefinition of(Block block) {
        return ItemDefinition.of(Item.func_150898_a((Block)block));
    }

    public static ItemDefinition of(Block block, int metadata) {
        return ItemDefinition.of(Item.func_150898_a((Block)block), metadata);
    }

    public static ItemDefinition of(Item item, int metadata) {
        return new ItemDefinition(item, metadata);
    }

    public static ItemDefinition parse(String string, boolean allowWildcard) {
        String[] parts = string.split(":");
        if (parts.length >= 2 && parts.length <= 3) {
            Item item;
            int meta = 0;
            if (parts.length == 3) {
                if (allowWildcard && parts[2].equals("*")) {
                    meta = Short.MAX_VALUE;
                } else {
                    try {
                        meta = Integer.parseInt(parts[2]);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!allowWildcard && meta == Short.MAX_VALUE) {
                        meta = 0;
                    }
                }
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(parts[0], parts[1]))) != null && item != Items.field_190931_a) {
                return new ItemDefinition(item, meta);
            }
        }
        Kiwi.logger.error("Fail to parse \"{}\" to ItemDefinition.", (Object)string);
        return EMPTY;
    }

    public ItemDefinition(Item item, int metadata) {
        this.item = item.delegate;
        this.metadata = metadata;
    }

    public Item getItem() {
        return (Item)this.item.get();
    }

    public int getMetadata() {
        return this.metadata;
    }

    @Override
    @Nonnull
    public List<ItemStack> examples() {
        if (this.metadata == Short.MAX_VALUE) {
            CreativeTabs itemGroup = ((Item)this.item.get()).func_77640_w();
            if (itemGroup != null) {
                NonNullList stacks = NonNullList.func_191196_a();
                ((Item)this.item.get()).func_150895_a(itemGroup, stacks);
                return stacks;
            }
            return Collections.emptyList();
        }
        return Collections.singletonList(this.getItemStack());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemDefinition that = (ItemDefinition)o;
        return this.item.equals(that.item) && this.metadata == that.metadata;
    }

    @Override
    public boolean matches(ItemStack stack) {
        return stack.func_77973_b().delegate == this.item && (Short.MAX_VALUE == this.metadata || stack.func_77960_j() == this.metadata);
    }

    @Override
    public int count() {
        return 1;
    }

    public int hashCode() {
        return this.item.hashCode() * 31 + this.metadata;
    }

    @Override
    public int compareTo(ItemDefinition o) {
        int result = this.item.name().compareTo(o.item.name());
        return result == 0 ? this.metadata - o.metadata : result;
    }

    public String toString() {
        return this.item.name() + ":" + (this.metadata != Short.MAX_VALUE ? Integer.valueOf(this.metadata) : "*");
    }

    public ItemStack getItemStack() {
        return new ItemStack((Item)this.item.get(), 1, this.metadata, null);
    }

    @Override
    public boolean isEmpty() {
        return this.item.get() == Items.field_190931_a;
    }
}

